// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "hw_pi.h"

void HwPI::ww_reset(Hardware *h, WORD offset, DWORD data) {
	MYASSERT(offset == 0x3024);
	if(data == 0) {
		throw emulation_stop_exception("GameCube reset! Emulation stopped.");
	} else if(data == 0x18) {
		throw emulation_stop_exception("GameCube reset (type 2). Emulation stopped.");
	} else {
		DEGUB("Writ to 0x3024: 0x%08X\n", data);
	}
	h->hww(offset, data);
}

DWORD HwPI::rw_reset(Hardware *h, WORD offset) {
	MYASSERT(offset == 0x3024);
	DWORD data = h->gcmfile.isOpen() ? -1 : 0;//0x80000000  //hack. it made bam3k lock up.
	DEGUB("Hardware rw: 0x%04X, 0x%08X\n", offset, data);
	return data;
}

void HwPI::ww_intsr(Hardware *, WORD offset, DWORD data) {
	MYASSERT(offset == 0x3000);
	if(g::log_interrupts) {
		DEGUB("PI INTSR ww ignored | 0x%08X\n", data);
	}
}

DWORD HwPI::rw_intsr(Hardware *h, WORD offset) {
	MYASSERT(offset == 0x3000);
	DWORD temp = h->hrw(offset) | 0x00010000; //hack
	if(g::log_interrupts) {
		DEGUB("PI INTSR rw: 0x%08X\n", temp);
	}
	h->hww(offset, 0);
	h->m_pisr_reads++;
	return temp;
}

void HwPI::ww_intmr(Hardware *h, WORD offset, DWORD data) {
	MYASSERT(offset == 0x3004);
	//DWORD intsr = h->hrw(0x3000) & ~data;
	if(g::log_interrupts) {
		//DEGUB("Hardware ww: 0x%04X, 0x%08X. INTSR cleared from 0x%08X to 0x%08X\n",
		//offset, data, h->hrw(0x3000), intsr);
		DEGUB("PI INTMR ww: 0x%08X\n", data);
	}
	//h->hww(0x3000, intsr);
	h->hww(offset, data);
}

DWORD HwPI::rw_console_type(Hardware *, WORD offset) {
	MYASSERT(offset == 0x302C);
	DEGUB("Hardware rw: 0x%04X, 0x%08X\n", offset, 0x30000000);
	return 0x30000000;  //hw3?
}
